﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.ServiceProcess

Public Class Form1

    ' 用于访问选定服务的实例。
    Private msvc As ServiceController
    Private controllers As New System.Collections.Generic.SortedList(Of String, ServiceController)

    Private Sub cmdPause_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPause.Click
        Try
            msvc.Pause()
            UpdateUIForSelectedService()
        Catch exp As Exception
            MsgBox("Cannot pause service.", MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub cmdResume_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdResume.Click
        Try
            msvc.Continue()
            UpdateUIForSelectedService()
        Catch exp As Exception
            MsgBox("Cannot resume service.", MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub cmdStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdStart.Click
        Try
            msvc.Start()
            UpdateUIForSelectedService()
        Catch exp As Exception
            MsgBox("Cannot start service.", MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub cmdStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdStop.Click
        Try
            msvc.Stop()
            UpdateUIForSelectedService()
        Catch exp As Exception
            MsgBox("Cannot stop service.", MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        EnumServices()
    End Sub

    Private Sub lvServices_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvServices.SelectedIndexChanged
        UpdateUIForSelectedService()
    End Sub

    Private Sub EnumServices()
        ' 获取可用服务列表并
        ' 用这些信息加载列表视图控件
        Try
            Me.ToolStripStatusLabel1.Text = "Loading Service List, pleasse wait"

            Me.lvServices.Items.Clear()

            If controllers IsNot Nothing Then
                controllers = New Generic.SortedList(Of String, ServiceController)
            End If

            Dim services As ServiceController() = ServiceController.GetServices()
            For Each controller As ServiceController In services
                With Me.lvServices.Items.Add(controller.DisplayName)
                    .SubItems.Add(controller.Status.ToString())
                    .SubItems.Add(controller.ServiceType.ToString())
                End With
                controllers.Add(controller.DisplayName, controller)
            Next controller
        Catch exp As Exception
            MsgBox("Cannot enumerate the services.")
        Finally
            ToolStripStatusLabel1.Text = "Ready"
        End Try
    End Sub

    Private Sub UpdateServiceStatus()
        ' 检查每项服务
        Try
            ToolStripStatusLabel1.Text = "Checking Service Status . . "
            Dim item As ListViewItem
            For Each item In Me.lvServices.Items
                msvc = controllers.Item(item.Text)
                msvc.Refresh()
                item.SubItems(1).Text = msvc.Status.ToString()
            Next item
            UpdateUIForSelectedService()
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            ToolStripStatusLabel1.Text = "Ready"
        End Try
    End Sub

    Private Sub UpdateUIForSelectedService()
        ' 为选定的服务更新命令按钮。
        Dim strName As String

        Try
            If Me.lvServices.SelectedItems.Count = 1 Then
                strName = Me.lvServices.SelectedItems(0).SubItems(0).Text
                msvc = controllers.Item(strName)
                With msvc
                    ' 如果它已停止，我们应当能够启动它
                    Me.cmdStart.Enabled = (.Status = ServiceControllerStatus.Stopped)
                    ' 检查是否允许我们尝试并停止它，并确保它
                    ' 尚未停止。
                    Me.cmdStop.Enabled = (.CanStop AndAlso (Not .Status = ServiceControllerStatus.Stopped))
                    ' 检查是否允许我们暂停它，并查看它是否
                    ' 尚未暂停。
                    Me.cmdPause.Enabled = (.CanPauseAndContinue AndAlso (Not .Status = ServiceControllerStatus.Paused))
                    ' 如果它已经暂停，我们必须能够继续执行它。
                    Me.cmdResume.Enabled = (.Status = ServiceControllerStatus.Paused)
                End With
            End If
        Catch exp As Exception
            MsgBox("Cannot update UI.", MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub RefreshToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshToolStripMenuItem.Click
        UpdateServiceStatus()
    End Sub

    Private Sub RelistMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripMenuItem2.Click
        EnumServices()
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
